/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.forge.compat.registries;

import com.fizzware.dramaticdoors.forge.DDRegistry;
import com.fizzware.dramaticdoors.forge.blocks.ShortFrameDoorBlock;
import com.fizzware.dramaticdoors.forge.blocks.TallFrameDoorBlock;
import com.fizzware.dramaticdoors.forge.compat.DDCompatAdvancement;
import com.fizzware.dramaticdoors.forge.compat.DDCompatRecipe;
import com.fizzware.dramaticdoors.forge.items.ShortDoorItem;
import com.fizzware.dramaticdoors.forge.items.TallDoorItem;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import oshi.util.tuples.Pair;

public class BlockCarpentryCompat {
    public static boolean initialized = false;
    public static ShortFrameDoorBlock SHORT_FRAME_DOOR;
    public static ShortFrameDoorBlock SHORT_ILLUSION_DOOR;
    public static TallFrameDoorBlock TALL_FRAME_DOOR;
    public static TallFrameDoorBlock TALL_ILLUSION_DOOR;

    public static void registerCompat() {
        if (initialized) {
            return;
        }
        initialized = true;
        BlockCarpentryCompat.registerBlocksItems();
        BlockCarpentryCompat.registerRecipes();
    }

    private static void registerBlocksItems() {
        DDRegistry.DOOR_BLOCKS_TO_REGISTER.add((Pair<String, Block>)new Pair((Object)"short_frame_door", (Object)SHORT_FRAME_DOOR));
        DDRegistry.DOOR_BLOCKS_TO_REGISTER.add((Pair<String, Block>)new Pair((Object)"tall_frame_door", (Object)TALL_FRAME_DOOR));
        DDRegistry.DOOR_BLOCKS_TO_REGISTER.add((Pair<String, Block>)new Pair((Object)"short_illusion_door", (Object)SHORT_ILLUSION_DOOR));
        DDRegistry.DOOR_BLOCKS_TO_REGISTER.add((Pair<String, Block>)new Pair((Object)"tall_illusion_door", (Object)TALL_ILLUSION_DOOR));
        DDRegistry.DOOR_ITEMS_TO_REGISTER.add((Pair<String, Item>)new Pair((Object)"short_frame_door", (Object)new ShortDoorItem(SHORT_FRAME_DOOR, DDRegistry.PROPERTIES.m_41491_(DDRegistry.MAIN_TAB))));
        DDRegistry.DOOR_ITEMS_TO_REGISTER.add((Pair<String, Item>)new Pair((Object)"tall_frame_door", (Object)new TallDoorItem(TALL_FRAME_DOOR, DDRegistry.PROPERTIES.m_41491_(DDRegistry.MAIN_TAB))));
        DDRegistry.DOOR_ITEMS_TO_REGISTER.add((Pair<String, Item>)new Pair((Object)"short_illusion_door", (Object)new ShortDoorItem(SHORT_ILLUSION_DOOR, DDRegistry.PROPERTIES.m_41491_(DDRegistry.MAIN_TAB))));
        DDRegistry.DOOR_ITEMS_TO_REGISTER.add((Pair<String, Item>)new Pair((Object)"tall_illusion_door", (Object)new TallDoorItem(TALL_ILLUSION_DOOR, DDRegistry.PROPERTIES.m_41491_(DDRegistry.MAIN_TAB))));
    }

    private static void registerRecipes() {
        DDCompatAdvancement.createRecipeAdvancement("short_frame_door", new ResourceLocation("blockcarpentry", "frame_door"));
        DDCompatAdvancement.createRecipeAdvancement("short_illusion_door", new ResourceLocation("blockcarpentry", "illusion_door"));
        DDCompatAdvancement.createRecipeAdvancement("tall_frame_door", new ResourceLocation("blockcarpentry", "frame_door"));
        DDCompatAdvancement.createRecipeAdvancement("tall_illusion_door", new ResourceLocation("blockcarpentry", "illusion_door"));
        DDCompatRecipe.createShortDoorRecipe("short_frame_door", new ResourceLocation("blockcarpentry", "frame_door"), true);
        DDCompatRecipe.createShortDoorRecipe("short_illusion_door", new ResourceLocation("blockcarpentry", "illusion_door"), true);
        DDCompatRecipe.createTallDoorRecipe("tall_frame_door", new ResourceLocation("blockcarpentry", "frame_door"), "tall_misc_door");
        DDCompatRecipe.createTallDoorRecipe("tall_illusion_door", new ResourceLocation("blockcarpentry", "illusion_door"), "tall_misc_door");
    }
}

